/*
This software module was originally developed by 
        Hang-Seop Lee (hslee@etri.re.kr), ETRI
        Jung-Chul Lee (jclee@etri.re.kr), ETRI
and edited by Hang-Seop Lee, Jung-Chul Lee of ETRI, 
in the course of development of the MPEG-4.
This software module is an implementation of a part of one or
more MPEG-4 tools as specified by the MPEG-4.
ISO/IEC gives users of the MPEG-4 free license to this                
software module or modifications thereof for use in hardware
or software products claiming conformance to the MPEG-4.
Those intending to use this software module in hardware or software
products are advised that its use may infringe existing patents.
The original developer of this software module and his/her company,
the subsequent editors and their companies, and ISO/IEC have no
liability for use of this software module or modifications thereof
in an implementation.
Copyright is not released for non MPEG-4 conforming
products. ETRI retains full right to use the code for his/her own
purpose, assign or donate the code to a third party and to
inhibit third parties from using the code for non
MPEG-4 conforming products.
This copyright notice must be included in all copies or
derivative works. Copyright (c) 1997.
*/    

// ModelessOptDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Modeless.h"
#include "ModelessOptDlg.h"
#include "ModelessTextDlg.h"
#include "ModelessDlg.h"
#include <string.h>
#include "vsay.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern	CModelessDlg* ppp;
char	szTEXTSTRING[800];
int		nS_MAX;			// m_slider_position max range ǥ
int		nSENTENCE;		// open file   .
int		nFILE;			// file open ¸ ǥ

extern int nPOS;
extern int rd_str(char *str, int *idx);

#define MALE		(int)0		// for Sex Radio button
#define FEMALE		(int)1
#define	SYNC_ON		(int)0		// for Lip Sync button
#define	SYNC_OFF	(int)1

/////////////////////////////////////////////////////////////////////////////
// CModelessOptDlg dialog

CModelessOptDlg* pOpt=NULL;

CModelessOptDlg::CModelessOptDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CModelessOptDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModelessOptDlg)
	m_radio_Sync = -1;
	//}}AFX_DATA_INIT
	m_pDlg = NULL;		// insert by ׼
}

// insert by ׼
CModelessOptDlg::CModelessOptDlg(CDialog* pDlg)		// modeless constructor
{
	m_pDlg = pDlg;
	m_radio_Sync = SYNC_ON;		// default setting for Lip Sync
	nFILE = FALSE;				// ó open    ˸
	pOpt = this;
}

CModelessOptDlg::~CModelessOptDlg()
{
	if (nFILE == TRUE)	
	{
		m_pTextDlg->DestroyWindow();
		delete	m_pTextDlg;
	}
}

BOOL CModelessOptDlg::Create()
{
	return CDialog::Create(IDD_OPTION_DIALOG);
}


void CModelessOptDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModelessOptDlg)
	DDX_Control(pDX, IDC_C_Default, m_check_default);
	DDX_Control(pDX, ID_CAPTION_ON, m_CaptionOn);
	DDX_Control(pDX, ID_CAPTION_OFF, m_CaptionOff);
	DDX_Control(pDX, IDC_R_Sync_Off, m_radio_SyncOff);
	DDX_Control(pDX, IDC_R_Sync_On, m_radio_SyncOn);
	DDX_Control(pDX, IDC_S_SpchRate, m_slider_SpchRate);
	DDX_Control(pDX, IDC_R_male, m_radio_male);
	DDX_Control(pDX, IDC_R_female, m_radio_female);
	DDX_Radio(pDX, IDC_R_Sync_On, m_radio_Sync);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CModelessOptDlg, CDialog)
	//{{AFX_MSG_MAP(CModelessOptDlg)
	ON_BN_CLICKED(IDC_R_female, OnRfemale)
	ON_BN_CLICKED(IDC_R_male, OnRmale)
	ON_BN_CLICKED(IDC_R_Sync_Off, OnRSyncOff)
	ON_BN_CLICKED(IDC_R_Sync_On, OnRSyncOn)
	ON_BN_CLICKED(IDC_B_Decoder, OnBDecoder)
	ON_BN_CLICKED(ID_CAPTION_ON, OnCaptionOn)
	ON_BN_CLICKED(ID_CAPTION_OFF, OnCaptionOff)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModelessOptDlg message handlers

void CModelessOptDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	if( m_pDlg != NULL )
	{
		m_pDlg->PostMessage(WM_GOODBYE, IDCANCEL);
	}
	
}

void CModelessOptDlg::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	if( m_pDlg != NULL )
	{
		m_pDlg->PostMessage(WM_GOODBYE, IDOK);
	}
	
}



BOOL CModelessOptDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	MoveWindow( 0, 144, 295, 214 );

	m_CaptionOff.EnableWindow( FALSE );
	m_radio_SyncOn.SetCheck(1);
	m_slider_SpchRate.SetRange(0, 9);
	m_slider_SpchRate.SetTicFreq(1);
	m_slider_SpchRate.SetPos(3);
	m_check_default.SetCheck(1);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CModelessOptDlg::OnRfemale() 
{
	// TODO: Add your control notification handler code here
	
}

void CModelessOptDlg::OnRmale() 
{
	// TODO: Add your control notification handler code here
	
}

void CModelessOptDlg::OnRSyncOff() 
{
	// TODO: Add your control notification handler code here
	m_radio_Sync = SYNC_OFF;
}

void CModelessOptDlg::OnRSyncOn() 
{
	// TODO: Add your control notification handler code here
	m_radio_Sync = SYNC_ON;
}

void CModelessOptDlg::OnBDecoder() 
{
	// TODO: Add your control notification handler code here
	m_radio_female.SetCheck(0);
	m_radio_male.SetCheck(0);
	m_slider_SpchRate.SetPos(3);

	if( MPEG4_Init() != TRUE )
		ppp->CallOnPlay();

}

void CModelessOptDlg::OnCaptionOn() 
{
	// TODO: Add your control notification handler code here
	// for Modeless Text dialog create
	m_pTextDlg = new CModelessTextDlg(this);	
	// create the dialog if not create already
	if( m_pTextDlg->GetSafeHwnd() == 0 )
	{
		if( m_pTextDlg->Create() == 0 )		// display the dialog window
		{
			AfxMessageBox("Failure of Modeless Caption Dialog Open");
		}
		else
		{
			m_CaptionOn.EnableWindow( FALSE );
			m_CaptionOff.EnableWindow( TRUE );
			nFILE = TRUE;	//  ϳ  open Ǿ ˸
		}
	}
	
}

void CModelessOptDlg::OnCaptionOff() 
{
	// TODO: Add your control notification handler code here
	nFILE = FALSE;		//  open    ˸
	m_CaptionOff.EnableWindow( FALSE );
	m_CaptionOn.EnableWindow( TRUE );
	m_pTextDlg->DestroyWindow();
	delete	m_pTextDlg;	
	
}
